import {createSelector} from 'reselect';
import mapValues from 'lodash/mapValues';

import {TAllSegments} from 'projects/trains/components/TrainsOrderSegments/types';

import orderTrainsSegmentsSelector from 'selectors/trains/orderTrainsSegmentsSelector';

import {getTrainFeatures} from 'projects/trains/lib/segments/features/getTrainFeatures';

export default createSelector(
    [orderTrainsSegmentsSelector],
    (segments): TAllSegments => {
        return mapValues(segments, direction => {
            return mapValues(direction, segment => {
                if (!segment) {
                    return null;
                }

                return {
                    arrival: segment.arrival,
                    departure: segment.departure,
                    stationFrom: segment.stationFrom,
                    stationTo: segment.stationTo,
                    number: segment.number,
                    title: segment.title,
                    originalArrival: segment.originalArrival,
                    isThroughCoachArrival: segment.isThroughCoachArrival,
                    eTicketStatus: Boolean(segment.tariffs?.electronicTicket),
                    features: getTrainFeatures(segment),
                };
            });
        });
    },
);
