import {createSelector} from 'reselect';
import moment from 'moment-timezone';

import {isFilledTrainsSearchContext} from 'reducers/trains/context/types';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';
import orderSegmentsSelector from 'selectors/trains/order/orderSegmentsSelector';

import {ROBOT} from 'utilities/dateUtils/formats';

export interface IOrderTripInfo {
    from: string;
    to: string;
    when: string;
    returnWhen?: string;
}

export default createSelector(
    [trainsContextSelector, orderSegmentsSelector],
    (context, orderSegments): IOrderTripInfo | null => {
        if (!isFilledTrainsSearchContext(context)) {
            return null;
        }

        const firstForwardSegment = orderSegments.FORWARD[0];

        if (!firstForwardSegment) {
            return null;
        }

        const when = moment(firstForwardSegment.departure)
            .tz(firstForwardSegment.stationFrom.timezone)
            .format(ROBOT);

        const firstBackwardSegment = orderSegments.BACKWARD[0];

        const returnWhen = firstBackwardSegment
            ? moment(firstBackwardSegment.departure)
                  .tz(firstBackwardSegment.stationFrom.timezone)
                  .format(ROBOT)
            : undefined;

        return {
            from: context.from.title,
            to: context.to.title,
            when,
            returnWhen,
        };
    },
);
