import {createSelector} from 'reselect';

import lastSegmentSelector from 'selectors/trains/order/passengers/lastSegmentSelector';

/**
 * Дата/время прибытия последнего сегмента в заказе
 * нужно для подсчета возраста пассажиров (на момент отправки последнего поезда)
 */
const lastSegmentArrivalSelector = createSelector(
    [lastSegmentSelector],
    (segment): string | undefined => {
        return segment?.arrival;
    },
);

export default lastSegmentArrivalSelector;
