import {createSelector} from 'reselect';

import lastSegmentSelector from 'selectors/trains/order/passengers/lastSegmentSelector';

/**
 * Дата/время отправления последнего сегмента в заказе
 * нужно для подсчета возраста пассажиров (на момент отправки последнего поезда)
 */
const lastSegmentDepartureSelector = createSelector(
    [lastSegmentSelector],
    (segment): string | undefined => {
        return segment?.departure;
    },
);

export default lastSegmentDepartureSelector;
