import {createSelector} from 'reselect';
import moment from 'moment';

import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';

import trainListSelector from 'selectors/trains/order/trainListSelector';

/**
 * Последний сегмент в заказе
 */
const lastSegmentSelector = createSelector(
    [trainListSelector],
    (trains): TTrainsStoreOrderSegment | null => {
        return trains.reduce<TTrainsStoreOrderSegment | null>((max, train) => {
            const {segment} = train;
            const segmentArrival = segment?.arrival;

            if (!segmentArrival) {
                return max;
            }

            if (!max) {
                return segment;
            }

            return moment(segmentArrival).isAfter(max.arrival) ? segment : max;
        }, null);
    },
);

export default lastSegmentSelector;
