import {createSelector} from 'reselect';

import {GENDER_TYPE} from 'projects/trains/constants/genders';

import trainListSelector from 'selectors/trains/order/trainListSelector';

/**
 * Возвращает пол для всего заказа
 * нужно для валидации формы пассажиров
 * любой гендер М или Ж перебивает null и все остальные из GENDER_TYPE
 */
const orderGenderSelector = createSelector(
    [trainListSelector],
    (trains): GENDER_TYPE | null => {
        return trains.reduce<GENDER_TYPE | null>((result, train) => {
            const {gender} = train;

            if (gender === GENDER_TYPE.MALE || gender === GENDER_TYPE.FEMALE) {
                return gender;
            }

            return result;
        }, null);
    },
);

export default orderGenderSelector;
