import {createStructuredSelector} from 'reselect';

import {GENDER_TYPE} from 'projects/trains/constants/genders';
import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

import {IWithDeviceType} from 'types/withDeviceType';
import {
    ITrainCountrySelect,
    TrainsPassengersCount,
} from 'reducers/trains/order/types';
import {IPassengerWithDocumentsAndBonusCardsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';
import {ITrainsTariffCategory} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {TUserInfo} from 'reducers/common/commonReducerTypes';
import {StoreInterface} from 'reducers/storeTypes';

import {getUserInfo} from 'selectors/common/userInfoSelector';
import deviceTypeSelector from 'selectors/common/deviceTypeSelector';
import passengersCountSelector from 'selectors/trains/order/passengersCountSelector';
import passengersWithDocumentsSelector from 'selectors/trains/order/passengers/passengersWithDocumentsSelector';
import seatsSelector from 'selectors/trains/order/passengers/seatsSelector';
import availableCountriesSelector from 'selectors/trains/order/availableCountriesSelector';
import orderGenderSelector from 'selectors/trains/order/passengers/orderGenderSelector';
import tariffCategoriesSelector from 'selectors/trains/order/tariffCategoriesSelector';
import allowedDocumentTypesSelector from 'selectors/trains/order/allowedDocumentTypesSelector';
import isCppkSelector from 'selectors/trains/order/isCppkSelector';
import lastSegmentDepartureSelector from 'selectors/trains/order/passengers/lastSegmentDepartureSelector';

interface IPassengersOrderStepSelector extends IWithDeviceType {
    userInfo: TUserInfo;
    seats: number[][];
    countries: ITrainCountrySelect[];
    passengers: TrainsPassengersCount;
    /** Документы из ЗКП для каждого пассажира в заказе */
    passengersWithDocuments: IPassengerWithDocumentsAndBonusCardsDTO[][];
    /**
     * Пол купе вычисленный для всех поездов в заказе
     */
    orderGender: GENDER_TYPE | null;

    tariffCategories: ITrainsTariffCategory[] | undefined;

    allowedDocumentTypes: TRAINS_DOCUMENT_TYPES[];

    isCppk: boolean;

    lastSegmentDeparture: string | undefined;
}

export default createStructuredSelector<
    StoreInterface,
    IPassengersOrderStepSelector
>({
    countries: availableCountriesSelector,
    deviceType: deviceTypeSelector,
    userInfo: getUserInfo,
    passengers: passengersCountSelector,
    passengersWithDocuments: passengersWithDocumentsSelector,
    seats: seatsSelector,
    orderGender: orderGenderSelector,
    tariffCategories: tariffCategoriesSelector,
    allowedDocumentTypes: allowedDocumentTypesSelector,
    isCppk: isCppkSelector,
    lastSegmentDeparture: lastSegmentDepartureSelector,
});
