import {createSelector} from 'reselect';

import {IPassengerWithDocumentsAndBonusCardsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';

import passengersDataSelector from 'selectors/trains/order/passengersDataSelector';
import tariffCategoriesSelector from 'selectors/trains/order/tariffCategoriesSelector';
import travelerSelector from 'selectors/trains/order/travelerSelector';
import lastSegmentDepartureSelector from 'selectors/trains/order/passengers/lastSegmentDepartureSelector';
import orderGenderSelector from 'selectors/trains/order/passengers/orderGenderSelector';

import getFilteredAccountPassengers from 'projects/trains/components/TrainsOrderPage/PassengersStep/utilities/getFilteredAccountPassengers';

/** Пассажиры с документами из ЗКП для каждого пассажира в заказе */
const passengersWithDocumentsSelector = createSelector(
    [
        passengersDataSelector,
        tariffCategoriesSelector,
        travelerSelector,
        lastSegmentDepartureSelector,
        orderGenderSelector,
    ],
    (
        passengersData,
        tariffCategories,
        traveler,
        lastSegmentDeparture,
        gender,
    ): IPassengerWithDocumentsAndBonusCardsDTO[][] => {
        const {accountPassengers} = traveler;

        return passengersData.map(passengerData => {
            if (!tariffCategories || !lastSegmentDeparture) {
                return accountPassengers;
            }

            return getFilteredAccountPassengers(
                accountPassengers,
                passengerData.ageGroup,
                gender,
                lastSegmentDeparture,
                tariffCategories,
            );
        });
    },
);

export default passengersWithDocumentsSelector;
