import {createSelector} from 'reselect';

import passengersCountSelector from 'selectors/trains/order/passengersCountSelector';
import trainsOrderSelector from 'selectors/trains/order/trainsOrderSelector';
import isMultipleTrainsSelector from 'selectors/trains/order/isMultipleTrainsSelector';

import {getPlacesSortedByPrice} from 'projects/trains/lib/order/getPlacesSortedByPrice';
import getFirstForwardCoach from 'projects/trains/lib/complexOrder/getFirstForwardCoach';
import getFirstForwardAdditionalSchemeInfo from 'projects/trains/lib/complexOrder/getFirstForwardAdditionalSchemeInfo';
import getFirstForwardTrain from 'projects/trains/lib/complexOrder/getFirstForwardTrain';

/**
 * Выбранные места для заголовков на странице пассажиров
 */
const seatsSelector = createSelector(
    [passengersCountSelector, trainsOrderSelector, isMultipleTrainsSelector],
    (passengers, order, isMultipleTrains: boolean): number[][] => {
        /**
         * Для сложного заказа не выводим места
         */
        if (isMultipleTrains) {
            return [];
        }

        const coach = getFirstForwardCoach(order);
        const additionalSchemeInfo = getFirstForwardAdditionalSchemeInfo(order);
        const train = getFirstForwardTrain(order);
        const beddingOption = train?.beddingOption ?? false;
        const nonRefundableTariff = train?.nonRefundableTariff ?? false;
        const orderPlaces = train?.orderPlaces ?? [];

        return getPlacesSortedByPrice({
            additionalSchemeInfo,
            beddingOption,
            coach,
            nonRefundableTariff,
            orderPlaces,
            passengers,
        });
    },
);

export default seatsSelector;
