import {createSelector} from 'reselect';

import {ITrainPassenger} from 'reducers/trains/order/types';

import trainsSelector from 'selectors/trains/order/trainsSelector';
import directionTrainsCountSelector from 'selectors/trains/order/directionTrainsCountSelector';
import orderPriceDetailsSelector from 'selectors/trains/order/orderPriceDetailsSelector';
import allowedDocumentTypesSelector from 'selectors/trains/order/allowedDocumentTypesSelector';
import passengersDataSelector from 'selectors/trains/order/passengersDataSelector';
import passengersCountSelector from 'selectors/trains/order/passengersCountSelector';

import getPassengersForOrder from 'projects/trains/lib/order/passengers/getPassengersForOrder';
import mapTrainsState, {
    TMapTrainsState,
} from 'projects/trains/lib/complexOrder/mapTrainsState';

export type TPassengersForOrder = TMapTrainsState<ITrainPassenger[]>;

const passengersForOrderSelector = createSelector(
    [
        trainsSelector,
        directionTrainsCountSelector,
        orderPriceDetailsSelector,
        allowedDocumentTypesSelector,
        passengersDataSelector,
        passengersCountSelector,
    ],
    (
        trains,
        directionTrainsCount,
        orderPriceDetails,
        allowedDocumentTypes,
        passengersData,
        passengers,
    ): TPassengersForOrder => {
        return mapTrainsState(trains, (train, direction, index) => {
            const priceDetails = orderPriceDetails[direction][Number(index)];

            const {
                nonRefundableTariff,
                coach,
                beddingOption,
                additionalSchemeInfo,
                orderPlaces,
            } = train;

            const nonRefundablePlaces = nonRefundableTariff
                ? priceDetails.nonRefundablePlaces
                : [];

            return getPassengersForOrder({
                nonRefundablePlaces,
                allowedDocumentTypes,
                passengersData,
                coach,
                beddingOption,
                additionalSchemeInfo,
                nonRefundableTariff,
                passengers,
                orderPlaces,
            });
        });
    },
);

export default passengersForOrderSelector;
