import {createSelector} from 'reselect';
import flatMap from 'lodash/flatMap';
import times from 'lodash/times';

import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {DIRECTIONS} from 'types/common/EDirection';

import {TOrderPlaceStepDescription} from 'reducers/trains/order/thunk/changeOrderStep';

import directionTrainsCountSelector from 'selectors/trains/order/directionTrainsCountSelector';

/**
 * Шаги выбора мест в заказе
 */
const placesStepsSelector = createSelector(
    [directionTrainsCountSelector],
    (directionTrainsCount): TOrderPlaceStepDescription[] => {
        return flatMap(DIRECTIONS, direction => {
            const trainCount = directionTrainsCount[direction];

            return times(trainCount, index => ({
                step: ORDER_STEP.PLACES,
                direction,
                index,
            }));
        });
    },
);

export default placesStepsSelector;
