import {createStructuredSelector} from 'reselect';

import {IStepRestrictionsData} from 'projects/trains/lib/order/stepRestrictions/types/IStepRestrictionsData';

import {StoreInterface} from 'reducers/storeTypes';

import passengersCountSelector from 'selectors/trains/order/passengersCountSelector';
import passengersDataSelector from 'selectors/trains/order/passengersDataSelector';
import allowedDocumentTypesSelector from 'selectors/trains/order/allowedDocumentTypesSelector';
import isCppkSelector from 'selectors/trains/order/isCppkSelector';
import currentCoachSelector from 'selectors/trains/order/currentCoachSelector';
import currentGenderSelector from 'selectors/trains/order/currentGenderSelector';
import currentExpandedServiceClassSelector from 'selectors/trains/order/currentExpandedServiceClassSelector';
import currentOrderPlacesSelector from 'selectors/trains/order/currentOrderPlacesSelector';
import currentPlacesViewTypeSelector from 'selectors/trains/order/currentPlacesViewTypeSelector';
import currentCoachTypeSelector from 'selectors/trains/order/currentCoachTypeSelector';
import currentAdditionalSchemeInfoSelector from 'selectors/trains/order/currentAdditionalSchemeInfoSelector';
import segmentDirectionSelector from 'selectors/trains/segmentDirectionSelector';
import segmentIndexSelector from 'selectors/trains/segmentIndexSelector';
import hasDifferentGenderInTrainsSelector from 'selectors/trains/order/hasDifferentGenderInTrainsSelector';
import nextOrderStepSelector from 'selectors/trains/order/nextOrderStepSelector';

const stepRestrictionsDataSelector = createStructuredSelector<
    StoreInterface,
    IStepRestrictionsData
>({
    direction: segmentDirectionSelector,
    index: segmentIndexSelector,
    passengers: passengersCountSelector,
    passengersData: passengersDataSelector,
    allowedDocumentTypes: allowedDocumentTypesSelector,
    isCppk: isCppkSelector,
    gender: currentGenderSelector,
    coach: currentCoachSelector,
    expandedServiceClass: currentExpandedServiceClassSelector,
    orderPlaces: currentOrderPlacesSelector,
    placesViewType: currentPlacesViewTypeSelector,
    coachType: currentCoachTypeSelector,
    additionalSchemeInfo: currentAdditionalSchemeInfoSelector,
    hasDifferentGenderInTrains: hasDifferentGenderInTrainsSelector,
    nextStep: nextOrderStepSelector,
});

export default stepRestrictionsDataSelector;
