import {ITrainsTariffCategory} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {StoreInterface} from 'reducers/storeTypes';

import trainsOrderSelector from 'selectors/trains/order/trainsOrderSelector';

import getFirstForwardTrainDetails from 'projects/trains/lib/complexOrder/getFirstForwardTrainDetails';

/**
 * Возрастные политики для заказа
 */
export default function tariffCategoriesSelector(
    state: StoreInterface,
): ITrainsTariffCategory[] | undefined {
    const order = trainsOrderSelector(state);
    /**
     * Пока договорились, что в заказе будут поезда с одинаковыми возрастными политиками
     */
    const trainDetails = getFirstForwardTrainDetails(order);

    return trainDetails?.tariffCategories;
}
