import {createSelector} from 'reselect';

import trainListSelector from 'selectors/trains/order/trainListSelector';

import {IPartnerError} from 'projects/trains/lib/errors/orderErrors';

export interface ITrainDetailsError {
    errors: boolean;
    partnerError: IPartnerError | null;
}

/**
 * Находим ошибки в любом из trainDetailsInfo в заказе
 */
const trainDetailsErrorSelector = createSelector(
    [trainListSelector],
    (trainList): ITrainDetailsError => {
        const trainDetailsInfoWithError = trainList
            .map(train => train.trainDetails)
            .find(trainDetailsInfo => trainDetailsInfo?.errors);

        if (!trainDetailsInfoWithError) {
            return {
                errors: false,
                partnerError: null,
            };
        }

        const {errors, partnerError} = trainDetailsInfoWithError;

        return {
            errors,
            partnerError,
        };
    },
);

export default trainDetailsErrorSelector;
