import {createSelector} from 'reselect';
import flatMap from 'lodash/flatMap';

import {ITrainOrderState, TTrainsOrderState} from 'reducers/trains/order/types';

import trainsSelector from 'selectors/trains/order/trainsSelector';

/**
 * Список всех поездов в заказе
 */
const trainListSelector = createSelector(
    [trainsSelector],
    (trains: TTrainsOrderState): ITrainOrderState[] => {
        return flatMap(Object.values(trains), directionTrains =>
            Object.values(directionTrains),
        );
    },
);

export default trainListSelector;
