import {createStructuredSelector} from 'reselect';

import {ORDER_PAGE_STATUSES} from 'projects/trains/constants/orderPageStatuses';
import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {TrainsSearchContextType} from 'reducers/trains/context/types';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';

import {StoreInterface} from 'reducers/storeTypes';
import {IDevice} from 'reducers/common/commonReducerTypes';
import {TOrderStepDescription} from 'reducers/trains/order/thunk/changeOrderStep';

import deviceTypeSelector from 'selectors/common/deviceTypeSelector';
import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';
import trainDetailsErrorSelector, {
    ITrainDetailsError,
} from 'selectors/trains/order/trainDetailsErrorSelector';
import nextOrderStepSelector from 'selectors/trains/order/nextOrderStepSelector';
import currentOrderPlacesSelector from 'selectors/trains/order/currentOrderPlacesSelector';
import orderPageStatusSelector from 'selectors/trains/order/orderPageStatusSelector';
import {orderStepSelector} from 'selectors/trains/order/orderStepSelector';
import orderInfoSelector from 'selectors/trains/order/orderInfoSelector';
import orderSegmentsSelector from 'selectors/trains/order/orderSegmentsSelector';
import currentSegmentDirectionAndIndexSelector from 'selectors/trains/order/currentSegmentDirectionAndIndexSelector';
import orderTripInfoSelector from 'selectors/trains/order/orderTripInfoSelector';

interface IOrderDataSelector {
    deviceType: IDevice;
    context: TrainsSearchContextType;
    trainDetailsError: ITrainDetailsError;
    nextOrderStep: TOrderStepDescription;
    currentOrderPlaces: number[];
    orderPageStatus: ORDER_PAGE_STATUSES;
    orderStep: ORDER_STEP;
    orderInfo: IGenericOrderInfo | null;
    trainSegments: ReturnType<typeof orderSegmentsSelector>;
    currentSegmentDirectionAndIndex: ReturnType<
        typeof currentSegmentDirectionAndIndexSelector
    >;
    orderTripInfo: ReturnType<typeof orderTripInfoSelector>;
}

const orderDataSelector = createStructuredSelector<
    StoreInterface,
    IOrderDataSelector
>({
    deviceType: deviceTypeSelector,
    context: trainsContextSelector,
    trainDetailsError: trainDetailsErrorSelector,
    nextOrderStep: nextOrderStepSelector,
    currentOrderPlaces: currentOrderPlacesSelector,
    orderPageStatus: orderPageStatusSelector,
    orderStep: orderStepSelector,
    orderInfo: orderInfoSelector,
    trainSegments: orderSegmentsSelector,
    currentSegmentDirectionAndIndex: currentSegmentDirectionAndIndexSelector,
    orderTripInfo: orderTripInfoSelector,
});

export default orderDataSelector;
