import {fromFieldSelector} from 'selectors/trains/searchForm/fromFieldSelector';
import {toFieldSelector} from 'selectors/trains/searchForm/toFieldSelector';
import {startDateSelector} from 'selectors/trains/searchForm/startDateSelector';
import {endDateSelector} from 'selectors/trains/searchForm/endDateSelector';
import {priceCalendarSelector} from 'selectors/trains/searchForm/priceCalendarSelector';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

import {checkIsRoundTripFieldSelector} from './checkIsRoundTripFieldSelector';

export default createTypedStructuredSelector({
    fromField: fromFieldSelector,
    toField: toFieldSelector,
    startDateField: startDateSelector,
    endDateField: endDateSelector,
    isRoundTripField: checkIsRoundTripFieldSelector,
    calendarPricesByType: priceCalendarSelector,
    previousSearches: state => state.trains.previousSearches,
    searchSuggests: state => state.trains.searchSuggests,
});
