import {createSelector} from 'reselect';

import featuresSelector from 'selectors/common/featuresSelector';
import orderTrainsSegmentsSelector from 'selectors/trains/orderTrainsSegmentsSelector';

import {shouldUseOwnOrderPage} from 'projects/trains/lib/order/shouldUseOwnOrderPage';

const shouldUseOwnOrderPageSelector = createSelector(
    [orderTrainsSegmentsSelector, featuresSelector],
    (trainsSegments, features) => {
        return Object.values(trainsSegments).every(directionSegments =>
            Object.values(directionSegments).every(
                segment => !segment || shouldUseOwnOrderPage(segment, features),
            ),
        );
    },
);

export default shouldUseOwnOrderPageSelector;
