import {createStructuredSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';
import deviceTypeSelector from 'selectors/common/deviceTypeSelector';
import trainsOrderSelector from 'selectors/trains/order/trainsOrderSelector';
import orderInfoSegmentsSelector from 'selectors/trains/order/orderInfoSegmentsSelector';
import orderPageStatusSelector from 'selectors/trains/order/orderPageStatusSelector';
import orderTripInfoSelector from 'selectors/trains/order/orderTripInfoSelector';
import trainsInfoSelector from 'selectors/trains/trainsInfoSelector';

interface IConfirmOrderStepSelector {
    order: ReturnType<typeof trainsOrderSelector>;
    context: ReturnType<typeof trainsContextSelector>;
    deviceType: ReturnType<typeof deviceTypeSelector>;
    trainSegments: ReturnType<typeof orderInfoSegmentsSelector>;
    orderPageStatus: ReturnType<typeof orderPageStatusSelector>;
    orderTripInfo: ReturnType<typeof orderTripInfoSelector>;
    trainInfo: ReturnType<typeof trainsInfoSelector>;
}

const trainsConfirmOrderStepSelector = createStructuredSelector<
    StoreInterface,
    IConfirmOrderStepSelector
>({
    order: trainsOrderSelector,
    context: trainsContextSelector,
    deviceType: deviceTypeSelector,
    trainSegments: orderInfoSegmentsSelector,
    orderPageStatus: orderPageStatusSelector,
    orderTripInfo: orderTripInfoSelector,
    trainInfo: trainsInfoSelector,
});

export default trainsConfirmOrderStepSelector;
