import moment, {Moment} from 'moment-timezone';
import {createSelector} from 'reselect';

import ITrainsOrderInfoStation from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoStation';

import trainDetailsSelector from 'selectors/trains/trainDetailsSelector';
import orderInfoSelector from 'selectors/trains/order/orderInfoSelector';

import {getFirstTrainService} from 'projects/trains/lib/complexOrder/getFirstTrainService';

export interface IOrderTrainInfo {
    stationFrom: ITrainsOrderInfoStation;
    stationTo: ITrainsOrderInfoStation;
    departureMoment: Moment;
    departureRailwayMoment: Moment;
    arrivalMoment: Moment;
    arrivalRailwayMoment: Moment;
    eTicketStatus: boolean;
}

const trainsInfoSelector = createSelector(
    trainDetailsSelector,
    orderInfoSelector,
    (trainDetails, orderInfo): IOrderTrainInfo | null => {
        const trainService = getFirstTrainService(orderInfo);

        if (!trainDetails || !trainService) {
            return null;
        }

        const {stationFrom, stationTo, departure, arrival} =
            trainService.trainInfo;

        return {
            stationTo,
            stationFrom,
            departureMoment: moment.tz(departure, stationFrom.timezone),
            departureRailwayMoment: moment.tz(
                departure,
                stationFrom.railwayTimezone,
            ),
            arrivalMoment: moment.tz(arrival, stationTo.timezone),
            arrivalRailwayMoment: moment.tz(arrival, stationTo.railwayTimezone),
            eTicketStatus: Boolean(trainDetails?.electronicTicket),
        };
    },
);

export default trainsInfoSelector;
