import {createStructuredSelector, Selector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

const createTypedStructuredSelector: <T>(
    selectors: {
        [K in keyof T]: Selector<StoreInterface, T[K]>;
    },
) => Selector<StoreInterface, T> = createStructuredSelector;

export default createTypedStructuredSelector;
