import {IDependencies} from 'server/getContainerConfig';
import {IAccountService} from 'server/services/AccountsService/AccountsService';

import {getProvider} from 'serviceProvider/core';

import {browserAccountProvider} from './browserAccountProvider';

export const accountProvider = {
    provider(container?: IDependencies): IAccountService {
        return getProvider<'accountsService', IAccountService>(
            browserAccountProvider,
            'accountsService',
        )(container);
    },
};
