import {
    IPassengerWithDocumentsDTO,
    IPassengerWithDocumentsAndBonusCardsDTO,
} from 'server/api/TravelersApi/types/IPassengerDTO';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IAccountService} from 'server/services/AccountsService/AccountsService';

export class BrowserAccountProvider
    extends BrowserHttpClient
    implements IAccountService
{
    constructor() {
        super({baseURL: '/api/account/'});
    }

    getPassengersWithDocuments = (): Promise<IPassengerWithDocumentsDTO[]> =>
        this.get<IPassengerWithDocumentsDTO[]>('passengersWithDocumentsGet');

    getPassengersWithDocumentsAndBonusCards = (): Promise<
        IPassengerWithDocumentsAndBonusCardsDTO[]
    > => this.get<IPassengerWithDocumentsAndBonusCardsDTO[]>('passengersGet');
}

export const browserAccountProvider = new BrowserAccountProvider();
