import {IAviaGetFlightPageService} from 'server/services/AviaService/types/IAviaGetFlightPageService';
import {IAviaInitByQueryService} from 'server/services/AviaVariantsService/types/IAviaInitByQueryService';
import {IAviaGetOrderService} from 'server/services/AviaOrderService/types/IAviaGetOrderService';
import {IAviaGetSuggestsService} from 'server/services/AviaService/types/IAviaGetSuggestsService';
import {IAviaGetGeoLookupService} from 'server/services/AviaService/types/IAviaGetGeoLookupService';
import {IAviaGetFlightsToData} from 'server/services/AviaFlightsToService/types/IAviaGetFlightsToData';
import {IAviaGetSearchToCountryPageService} from 'server/services/AviaService/types/IAviaGetSearchToCountryPageService';
import {
    IAviaGeoService,
    IAviaGeoServiceGetCountries,
    IAviaGeoServiceGetCountry,
    IAviaGeoServiceGetDataByGeoId,
    IAviaGeoServiceGetDataByPointKey,
    IAviaGeoServiceGetDirectionsData,
} from 'server/services/AviaGeoService/types/IAviaGeoService';
import {IAviaGetSearchToAnywherePageService} from 'server/services/AviaService/types/IAviaGetSearchToAnywherePageService';
import {IAviaGetExtendedCountryRestrictionsService} from 'server/services/AviaService/types/IAviaGetCountryRestrictionsService';
import {IPassengerExperience} from 'projects/avia/types/IPassengerExperience';
import {ISubscriptionsAnswer} from 'server/api/AviaApi/types/subscriptions';
import {IAviaTDAnswer} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';
import {IAviaRedirectPageParams} from 'server/api/AviaTicketDaemonApi/types/IAviaTDRedirect';
import {INearAnswer} from 'server/services/AviaNearService/types/IAviaNear';
import {IAviaRedirectVariantStatus} from 'server/services/AviaRedirectService/types/IAviaRedirectVariantStatus';
import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';
import {
    IAviaTopFlightsParams,
    IAviaTopFlights,
} from 'server/services/AviaSearchService/types/IAviaTopFlights';
import {TAviaGetPassengerExperience} from 'server/services/AviaPassengerExperienceService/types/IAviaGetPassengerExperience';

import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';
import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';
import IPrice from 'utilities/currency/PriceInterface';

import {ISchedule} from 'server/services/AviaFlexibleService/AviaFlexibleService';
import {IPartner} from 'server/api/AviaPartnersApi/AviaPartnersApi';
import {
    IAviaRouteService,
    TAviaGetRouteData,
} from 'server/services/AviaRouteService/AviaRouteService';
import {IAviaFlightsToService} from 'server/services/AviaFlightsToService/AviaFlightsToService';
import {IAviaOrderService} from 'server/services/AviaOrderService/AviaOrderService';
import {IAviaVariantsService} from 'server/services/AviaVariantsService/AviaVariantsService';
import {IAviaService} from 'server/services/AviaService/AviaService';

export interface IGenerateMarkerResponse {
    marker: string;
}

export class AviaBrowserProvider
    extends BrowserHttpClient
    implements
        IAviaVariantsService,
        IAviaService,
        IAviaOrderService,
        IAviaFlightsToService,
        IAviaGeoService,
        IAviaRouteService
{
    constructor() {
        super({baseURL: '/api/avia/'});
    }

    getGeoLookup: IAviaGetGeoLookupService = params =>
        this.get('geoLookup', {params});

    getSuggests: IAviaGetSuggestsService = params =>
        this.get('searchSuggest', {params});

    getFlightPage: IAviaGetFlightPageService = params =>
        this.get('getFlightPage', {params});

    initByQuery: IAviaInitByQueryService = params =>
        this.get('search/init', {params});

    getOrder: IAviaGetOrderService = params => this.get('getOrder', {params});

    getFlightsToData: IAviaGetFlightsToData = params =>
        this.get('flightsTo', {params});

    getExtendedCountryRestrictions: IAviaGetExtendedCountryRestrictionsService =
        params => this.get('extendedCountryRestrictions', {params});

    getSearchToCountryPage: IAviaGetSearchToCountryPageService = params => {
        const {
            passengers: {adults, children, infants},
        } = params;

        return this.get('searchToCountry', {
            params: {...params, adults, children, infants},
        });
    };

    getSearchToAnywherePage: IAviaGetSearchToAnywherePageService = params => {
        const {
            passengers: {adults, children, infants},
        } = params;

        return this.get('searchToAnywhere', {
            params: {...params, adults, children, infants},
        });
    };

    getCountry: IAviaGeoServiceGetCountry = id =>
        this.get('geo/getCountry', {params: {id}});

    getCountries: IAviaGeoServiceGetCountries = () =>
        this.get('geo/getCountries');

    getDataByGeoId: IAviaGeoServiceGetDataByGeoId = id =>
        this.get('geo/getDataByGeoId', {params: {id}});

    getDataByPointKey: IAviaGeoServiceGetDataByPointKey = key =>
        this.get('dataByPointKey', {params: {key}});

    getDirectionsData: IAviaGeoServiceGetDirectionsData = params =>
        this.get('geo/getDirectionsData', {params});

    getRouteData: TAviaGetRouteData = params => this.get('route', {params});

    getPassengerExperience: TAviaGetPassengerExperience = params =>
        this.get<IPassengerExperience>('/order/passengerExperience', {
            params,
        });

    // TODO: методы ниже сейчас используются в разных местах без провайдера, нужно это исправить

    initSearch = (params: IAviaParams): Promise<{id: string}> => {
        return this.get<{id: string}>('/search/init', {params});
    };

    getSearchResults = (
        qid: string,
        cont: number | null,
        allowPortional = 1,
        requestOptions?: IRequestConfig,
    ): Promise<IAviaTDAnswer> =>
        this.get<IAviaTDAnswer>('/search/results', {
            ...requestOptions,
            params: {qid, cont, allowPortional},
        });

    getPopularPartners = (params: IAviaParams): Promise<string[]> =>
        this.get<string[]>('/search/popular-partners', {params});

    updateOffers = (qid: string, cont: number | null): Promise<IAviaTDAnswer> =>
        this.get<IAviaTDAnswer>('/order/update/', {params: {qid, cont}});

    checkVariantExistence = (
        params: IAviaRedirectPageParams,
    ): Promise<IAviaRedirectVariantStatus> =>
        this.get<IAviaRedirectVariantStatus>('/redirect/check', {
            params,
        });

    getNearAirports = (params: IAviaParams): Promise<INearAnswer> =>
        this.get<INearAnswer>('nearAirports', {params});

    subscribeByEmail = (
        qid: string,
        email: string,
        minPrice: IPrice,
    ): Promise<{id: string; needsConfirmation: boolean}> =>
        this.post<{id: string; needsConfirmation: boolean}>(
            '/subscription/subscribe-by-email',
            {
                qid,
                email,
                minPrice,
            },
        );

    unsubscribeByDirection = (qid: string, id: string): Promise<void> =>
        this.post('/subscription/unsubscribe-by-direction', {
            qid,
            id,
        });

    subscriptions = (qid: string): Promise<ISubscriptionsAnswer> =>
        this.post<ISubscriptionsAnswer>('/subscription/subscriptions', {
            qid,
        });

    getPopularFlights = (
        params: IAviaTopFlightsParams,
    ): Promise<IAviaTopFlights> =>
        this.get<IAviaTopFlights>('/search/popular-flights', {
            params,
        });

    getSchedule = (params: IAviaParams): Promise<ISchedule> =>
        this.get<ISchedule>('/flexible/schedule', {params});

    getPartnersInfo = (): Promise<Record<string, IPartner>> =>
        this.get('/partnersInfo');
}

const aviaBrowserProvider = new AviaBrowserProvider();

export default aviaBrowserProvider;
