import {IDependencies} from 'server/getContainerConfig';
import {IAviaFlightsToService} from 'server/services/AviaFlightsToService/AviaFlightsToService';

import {getProvider} from 'serviceProvider/core';
import aviaBrowserProvider from 'serviceProvider/avia/aviaBrowserProvider';

export const aviaFlightsToProvider = {
    provider(container?: IDependencies): IAviaFlightsToService {
        return getProvider<'aviaFlightsToService', IAviaFlightsToService>(
            aviaBrowserProvider,
            'aviaFlightsToService',
        )(container);
    },
};
