import {IAviaGeoService} from 'server/services/AviaGeoService/types/IAviaGeoService';

import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';
import aviaBrowserProvider from 'serviceProvider/avia/aviaBrowserProvider';

export const aviaGeoProvider = {
    provider(container?: IDependencies): IAviaGeoService {
        return getProvider<'aviaGeoService', IAviaGeoService>(
            aviaBrowserProvider,
            'aviaGeoService',
        )(container);
    },
};
