import {IDependencies} from 'server/getContainerConfig';
import {IAviaOrderService} from 'server/services/AviaOrderService/AviaOrderService';

import {getProvider} from 'serviceProvider/core';
import aviaBrowserProvider from 'serviceProvider/avia/aviaBrowserProvider';

export const aviaOrderProvider = {
    provider(container?: IDependencies): IAviaOrderService {
        return getProvider<'aviaOrderService', IAviaOrderService>(
            aviaBrowserProvider,
            'aviaOrderService',
        )(container);
    },
};
