import {IDependencies} from 'server/getContainerConfig';
import {IAviaPassengerExperienceService} from 'server/services/AviaPassengerExperienceService/AviaPassengerExperienceService';

import {getProvider} from 'serviceProvider/core';
import aviaBrowserProvider from 'serviceProvider/avia/aviaBrowserProvider';

export const aviaPassengerExperienceProvider = {
    provider(container?: IDependencies): IAviaPassengerExperienceService {
        return getProvider<
            'aviaPassengerExperienceService',
            IAviaPassengerExperienceService
        >(
            aviaBrowserProvider,
            'aviaPassengerExperienceService',
        )(container);
    },
};
