import {IAviaPriceIndexSearchInterval} from 'server/api/AviaPriceIndexApi/types/IAviaPriceIndexSearchInterval';
import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';
import {TAviaPriceIndexDynamicsData} from 'server/api/AviaPriceIndexApi/types/TAviaPriceIndexDynamicsData';
import {IAviaMinPriceBatchSearchService} from 'server/services/AviaPriceIndexService/types/IAviaMinPriceBatchSearchService';
import {IAviaCalendarPriceIndexService} from 'server/services/AviaPriceIndexService/types/IAviaCalendarPriceIndexService';

import {IAviaSearchResultsFilters} from 'reducers/avia/search/results/filters/reducer';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

/**
 * TODO: refactoring required
 * @deprecated
 * */
class AviaPriceIndexBrowserProvider extends BrowserHttpClient {
    constructor() {
        super({baseURL: '/api/avia/'});
    }

    getCalendarPrices: IAviaCalendarPriceIndexService = params =>
        this.get('calendar-prices', {params});

    dynamics(
        interval: IAviaPriceIndexSearchInterval,
        params: IAviaParams,
        filters: Partial<IAviaSearchResultsFilters>,
    ): Promise<TAviaPriceIndexDynamicsData> {
        return this.post<TAviaPriceIndexDynamicsData>(
            '/dynamics',
            {
                data: filters,
            },
            {
                params: {...interval, ...params},
            },
        );
    }

    minPriceBatchSearch: IAviaMinPriceBatchSearchService = params => {
        return this.post('minPriceBatchSearch', params);
    };
}

/** @deprecated */
export const aviaPriceIndexBrowserProvider =
    new AviaPriceIndexBrowserProvider();
