import {IDependencies} from 'server/getContainerConfig';
import {IAviaService} from 'server/services/AviaService/AviaService';

import {getProvider} from 'serviceProvider/core';
import aviaBrowserProvider from 'serviceProvider/avia/aviaBrowserProvider';

export const aviaProvider = {
    provider(container?: IDependencies): IAviaService {
        return getProvider<'aviaService', IAviaService>(
            aviaBrowserProvider,
            'aviaService',
        )(container);
    },
};
