import {IDependencies} from 'server/getContainerConfig';
import {IAviaRouteService} from 'server/services/AviaRouteService/AviaRouteService';

import {getProvider} from 'serviceProvider/core';
import aviaBrowserProvider from 'serviceProvider/avia/aviaBrowserProvider';

export const aviaRouteProvider = {
    provider(container?: IDependencies): IAviaRouteService {
        return getProvider<'aviaRouteService', IAviaRouteService>(
            aviaBrowserProvider,
            'aviaRouteService',
        )(container);
    },
};
