import {IDependencies} from 'server/getContainerConfig';
import {IAviaVariantsService} from 'server/services/AviaVariantsService/AviaVariantsService';

import {getProvider} from 'serviceProvider/core';
import aviaBrowserProvider from 'serviceProvider/avia/aviaBrowserProvider';

export const aviaVariantsProvider = {
    provider(container?: IDependencies): IAviaVariantsService {
        return getProvider<'aviaVariantsService', IAviaVariantsService>(
            aviaBrowserProvider,
            'aviaVariantsService',
        )(container);
    },
};
