import {IShowLogVariant} from 'server/loggers/avia/AviaShowLog/types/IShowLogVariant';
import {IAviaActionLogParamsServer} from 'server/loggers/avia/AviaActionLog/types/IAviaActionLogParamsServer';

import {AviaBrowserProvider} from '../aviaBrowserProvider';

class AviaLoggingBrowserProvider extends AviaBrowserProvider {
    userSearch = (qid: string | null, page: string): Promise<void> =>
        this.post(`/log/userSearch`, {qid, page});

    show = (
        variants: IShowLogVariant[],
        session: string,
        actionId: string,
    ): Promise<void> =>
        this.post(`/log/show`, {
            variants,
            session,
            actionId,
        });

    action = (
        session: string,
        actionId: string,
        action: string,
        params: IAviaActionLogParamsServer,
    ): Promise<void> =>
        this.post('/log/action', {
            session,
            actionId,
            action,
            params,
        });

    landingVisit = (): void => {
        this.post('/log/landingVisit');
    };
}

export const aviaLoggingBrowserProvider = new AviaLoggingBrowserProvider();
