import {TFeatureFlags} from 'types/IFeatureFlags';
import {ITrainPopularRoutesResponse} from 'server/api/BunkerApi/types/trainPopularRoutes';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IBunkerService} from 'server/services/BunkerService/BunkerService';

export class BrowserBunkerProvider
    extends BrowserHttpClient
    implements IBunkerService
{
    constructor() {
        super({baseURL: '/api/bunker/'});
    }

    getTrainPopularRoutes = (): Promise<ITrainPopularRoutesResponse> =>
        this.get<ITrainPopularRoutesResponse>('getTrainPopularRoutes');

    getFeatureFlags = (): Promise<TFeatureFlags> =>
        this.get<TFeatureFlags>('getFeatureFlags');
}

export const browserBunkerProvider = new BrowserBunkerProvider();
