import {IDependencies} from 'server/getContainerConfig';
import {IBunkerService} from 'server/services/BunkerService/BunkerService';

import {getProvider} from 'serviceProvider/core';

import {browserBunkerProvider} from './browserBunkerProvider';

export const bunker = {
    provider(container?: IDependencies): IBunkerService {
        return getProvider<'bunkerService', IBunkerService>(
            browserBunkerProvider,
            'bunkerService',
        )(container);
    },
};
