import {CREATE_RIDE_OFFER_TIMEOUT} from 'server/api/BusesTravelApi/constants';

import {IBusesGetSuggestsService} from 'server/services/BusesService/types/IBusesGetSuggestsService';
import {IBusesGetSegmentsService} from 'server/services/BusesService/types/IBusesGetSegmentsService';
import {IBusesGetGeoPointsService} from 'server/services/BusesService/types/IBusesGetGeoPointsService';
import {IBusesGetPopularDirectionsService} from 'server/services/BusesService/types/IBusesGetPopularDirectionsService';
import {IBusesGetRideService} from 'server/services/BusesService/types/IBusesGetRideService';
import {IBusesGetCalendarService} from 'server/services/BusesService/types/IBusesGetCalendarService';
import {IBusesCreateRideOfferBrowserProviderParams} from 'serviceProvider/buses/types/IBusesCreateRideOfferBrowserProviderParams';
import {TBusesCreateRideOfferApiResponse} from 'server/api/BusesTravelApi/types/TBusesCreateRideOfferApiResponse';
import {IBusesGetTestContextService} from 'server/services/BusesService/types/IBusesGetTestContextService';
import {IBusesGetDirection} from 'server/services/BusesService/types/IBusesGetDirection';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IBusesService} from 'server/services/BusesService/BusesService';

export class BusesBrowserProvider
    extends BrowserHttpClient
    implements IBusesService
{
    constructor() {
        super({baseURL: '/api/buses'});
    }

    getSuggests: IBusesGetSuggestsService = params =>
        this.get('getSuggests', {params});

    getGeoPoints: IBusesGetGeoPointsService = params =>
        this.get('getGeoPoints', {params});

    getPopularDirections: IBusesGetPopularDirectionsService = params =>
        this.get('getPopularDirections', {params});

    getSegments: IBusesGetSegmentsService = params =>
        this.get('getSegments', {params});

    getCalendar: IBusesGetCalendarService = params =>
        this.get('getCalendar', {params});

    getRide: IBusesGetRideService = params => this.get('getRide', {params});

    createRideOffer(
        params: IBusesCreateRideOfferBrowserProviderParams,
    ): Promise<TBusesCreateRideOfferApiResponse> {
        return this.post('createRideOffer', params, {
            timeout: CREATE_RIDE_OFFER_TIMEOUT,
        });
    }

    getDirection: IBusesGetDirection = params =>
        this.get('getDirection', {params});

    getTestContext: IBusesGetTestContextService = params =>
        this.get('getTestContext', {params});
}

export const busesBrowserProvider = new BusesBrowserProvider();
