import {ICurrenciesInfo} from 'server/services/CurrenciesService/types';
import {IStoreTinyUrlApi} from 'server/api/TinyUrl/types/IStoreTinyUrlApi';
import {IRestoreTinyUrlApi} from 'server/api/TinyUrl/types/IRestoreTinyUrlApi';
import {TRestoreTinyUrlServiceAnswer} from 'server/services/TinyUrlService/types/IRestoreTinyUrlService';
import {TStoreTinyUrlServiceAnswer} from 'server/services/TinyUrlService/types/IStoreTinyUrlService';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

export class CommonBrowserProvider extends BrowserHttpClient {
    constructor() {
        super({
            baseURL: '/api/common',
        });
    }

    getCurrenciesInfo = (): Promise<ICurrenciesInfo> => {
        return this.get<ICurrenciesInfo>('currencies');
    };

    store = (
        storeTinyUrlParams: IStoreTinyUrlApi,
    ): Promise<TStoreTinyUrlServiceAnswer> =>
        this.get<TStoreTinyUrlServiceAnswer>('storeTinyUrl', {
            params: storeTinyUrlParams,
        });

    restore = (
        restoreTinyUrlParams: IRestoreTinyUrlApi,
    ): Promise<TRestoreTinyUrlServiceAnswer> =>
        this.get<TRestoreTinyUrlServiceAnswer>('restoreTinyUrl', {
            params: restoreTinyUrlParams,
        });
}

export const commonBrowserProvider = new CommonBrowserProvider();
