import {
    ICrossLinksApiResponse,
    ICrossLinksApiParams,
} from 'server/api/CommonApi/types/CrossLinks';
import {ICommonService} from 'server/services/CommonService/types';
import {IGetUserYandexPlusInfoResponse} from 'server/api/CommonApi/types/YandexPlus';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

export class CommonBrowserProvider
    extends BrowserHttpClient
    implements ICommonService
{
    constructor() {
        super({baseURL: '/api/common/'});
    }

    getCrossLinks = (
        params: ICrossLinksApiParams,
    ): Promise<ICrossLinksApiResponse> => {
        return this.get<ICrossLinksApiResponse>('crossLinks/getCrossLinks', {
            params,
        });
    };

    getUserYandexPlusInfo = (): Promise<IGetUserYandexPlusInfoResponse> => {
        return this.get<IGetUserYandexPlusInfoResponse>(
            'yandexPlus/getUserYandexPlusInfo',
        );
    };
}

export const browserCrossLinksProvider = new CommonBrowserProvider();
