import {ICommonService} from 'server/services/CommonService/types';

import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {browserCrossLinksProvider} from './commonBrowserProvider';

export const commonProvider = {
    provider(container?: IDependencies): ICommonService {
        return getProvider<'commonService', ICommonService>(
            browserCrossLinksProvider,
            'commonService',
        )(container);
    },
};
