import {IDependencies} from 'server/getContainerConfig';
import {ICrossSearchService} from 'server/services/CrossSearchService/CrossSearchService';

import {getProvider} from 'serviceProvider/core';

import {crossSearchBrowserProvider} from './crossSearchBrowserProvider';

export const crossSearchProvider = {
    provider(container?: IDependencies): ICrossSearchService {
        return getProvider<'crossSearchService', ICrossSearchService>(
            crossSearchBrowserProvider,
            'crossSearchService',
        )(container);
    },
};
