import IExperimentsService from 'server/services/ExperimentsService/types/IExperimentsService';
import {TUaasExperiments} from '@yandex-data-ui/core/lib/types';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

export class BrowserExperimentsProvider
    extends BrowserHttpClient
    implements IExperimentsService
{
    constructor() {
        super({baseURL: '/api/common/'});
    }

    getExperiments = (): Promise<TUaasExperiments | null> => {
        return this.get<TUaasExperiments | null>('experiments');
    };
}

export const browserExperimentsProvider = new BrowserExperimentsProvider();
