import {IDependencies} from 'server/getContainerConfig';
import {IGeobaseService} from 'server/services/GeobaseService/GeobaseService';

import {getProvider} from 'serviceProvider/core';

import {browserGeobaseProvider} from './browserGeobaseProvider';

export const geobaseProvider = {
    provider(container?: IDependencies): IGeobaseService {
        return getProvider<'geobaseService', IGeobaseService>(
            browserGeobaseProvider,
            'geobaseService',
        )(container);
    },
};
