import IGenericOrderService from 'server/services/GenericOrderService/types/IGenericOrderService';

import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {genericOrderBrowserProvider} from './genericOrderBrowserProvider';

export const genericOrderProvider = {
    provider(container?: IDependencies): IGenericOrderService {
        return getProvider<'genericOrderService', IGenericOrderService>(
            genericOrderBrowserProvider,
            'genericOrderService',
        )(container);
    },
};
