import {IHotelSearchService} from 'server/services/HotelsServices/HotelSearchService';
import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {browserHotelSearchProvider} from './browserHotelSearchProvider';

export const hotelSearch = {
    provider(container?: IDependencies): IHotelSearchService {
        return getProvider<'hotelSearchService', IHotelSearchService>(
            browserHotelSearchProvider,
            'hotelSearchService',
        )(container);
    },
};
