import {HOTELS_BASE_API} from 'projects/hotels/constants/hotelsAPI';

import IAddFavoriteHotelRequestParams from 'server/api/HotelsFavoritesAPI/types/IAddFavoriteHotelRequestParams';
import {TAddFavoriteHotelResponse} from 'server/api/HotelsFavoritesAPI/types/TAddFavoriteHotelResponse';
import IRemoveFavoriteHotelsResponse from 'server/api/HotelsFavoritesAPI/types/IRemoveFavoriteHotelsResponse';
import {TRemoveFavoriteHotelsRequestParams} from 'server/api/HotelsFavoritesAPI/types/IRemoveFavoriteHotelsRequestParams';
import IGetFavoriteHotelsResponse from 'server/api/HotelsFavoritesAPI/types/IGetFavoriteHotelsResponse';
import IGetFavoriteHotelsRequestParams from 'server/api/HotelsFavoritesAPI/types/IGetFavoriteHotelsRequestParams';
import IGetFavoriteHotelsOffersRequestParams from 'server/api/HotelsFavoritesAPI/types/IGetFavoriteHotelsOffersRequestParams';
import IGetFavoriteHotelsOffersResponse from 'server/api/HotelsFavoritesAPI/types/IGetFavoriteHotelsOffersResponse';
import IShareFavoriteHotelsRequestParams from 'server/api/HotelsFavoritesAPI/types/IShareFavoriteHotelsRequestParams';
import IShareFavoriteHotelsResponse from 'server/api/HotelsFavoritesAPI/types/IShareFavoriteHotelsResponse';
import IGetSharedFavoriteHotelsRequestParams from 'server/api/HotelsFavoritesAPI/types/IGetSharedFavoriteHotelsRequestParams';
import IGetSharedFavoriteHotelsResponse from 'server/api/HotelsFavoritesAPI/types/IGetSharedFavoriteHotelsResponse';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IHotelsFavoritesService} from 'server/services/HotelsServices/HotelsFavoritesService';

export class BrowserHotelsFavoritesProvider
    extends BrowserHttpClient
    implements IHotelsFavoritesService
{
    constructor() {
        super({baseURL: HOTELS_BASE_API});
    }

    addFavoriteHotel = (
        params: IAddFavoriteHotelRequestParams,
    ): Promise<TAddFavoriteHotelResponse> => {
        return this.post<TAddFavoriteHotelResponse>(
            `/addFavoriteHotel`,
            undefined,
            {params},
        );
    };

    removeFavoriteHotels = (
        params: TRemoveFavoriteHotelsRequestParams,
    ): Promise<IRemoveFavoriteHotelsResponse> => {
        return this.post<IRemoveFavoriteHotelsResponse>(
            `/removeFavoriteHotels`,
            undefined,
            {params},
        );
    };

    getFavoriteHotels = (
        params: IGetFavoriteHotelsRequestParams,
    ): Promise<IGetFavoriteHotelsResponse> => {
        return this.get<IGetFavoriteHotelsResponse>(`/getFavoriteHotels`, {
            params,
        });
    };

    getFavoriteHotelsOffers = (
        params: IGetFavoriteHotelsOffersRequestParams,
    ): Promise<IGetFavoriteHotelsOffersResponse> => {
        return this.get<IGetFavoriteHotelsOffersResponse>(
            `getFavoriteHotelsOffers`,
            {params},
        );
    };

    shareFavoriteHotels = async (
        params: IShareFavoriteHotelsRequestParams,
    ): Promise<IShareFavoriteHotelsResponse> => {
        const response = await this.post<{data: IShareFavoriteHotelsResponse}>(
            `shareFavoriteHotels`,
            undefined,
            {params},
        );

        return response.data;
    };

    getSharedFavoriteHotels = (
        params: IGetSharedFavoriteHotelsRequestParams,
    ): Promise<IGetSharedFavoriteHotelsResponse> => {
        return this.get<IGetSharedFavoriteHotelsResponse>(
            'getSharedFavoriteHotels',
            {params},
        );
    };
}

export const browserHotelsFavoritesProvider =
    new BrowserHotelsFavoritesProvider();
