import {
    HOTELS_BASE_API,
    SEARCH_HOTELS_POLLING,
    SEARCH_SUGGEST,
    SEARCH_COUNT_HOTELS,
    LOG_SEARCH_SUGGEST,
    GEO_REGION_INFO,
} from 'projects/hotels/constants/hotelsAPI';

import {
    ISearchHotelsInfoRequestParams,
    ISearchHotelsInfo,
} from 'server/api/HotelsSearchAPI/types/ISearchHotels';
import {
    ISearchSuggestRequestParams,
    ISearchSuggestResponse,
} from 'server/api/HotelsSearchAPI/types/ISearchSuggest';
import {
    ILogSearchSuggestRequestParams,
    ILogSearchSuggestResponse,
} from 'server/api/HotelsSearchAPI/types/ILogSearchSuggest';
import {
    ICountHotelsRequestParams,
    ICountHotelsResponse,
} from 'server/api/HotelsSearchAPI/types/ICountHotels';
import {
    IGeoRegionInfoRequestParams,
    IGeoRegionInfoResponse,
} from 'server/api/HotelsSearchAPI/types/IGeoRegionInfo';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IHotelsSearchService} from 'server/services/HotelsServices/HotelsSearchService';

export class BrowserHotelsSearchProvider
    extends BrowserHttpClient
    implements IHotelsSearchService
{
    constructor() {
        super({baseURL: HOTELS_BASE_API});
    }

    searchSuggest = (
        searchSuggestParams: ISearchSuggestRequestParams,
    ): Promise<ISearchSuggestResponse> =>
        this.get<ISearchSuggestResponse>(SEARCH_SUGGEST, {
            params: searchSuggestParams,
        });

    logSearchSuggest = (
        logSearchSuggestParams: ILogSearchSuggestRequestParams,
    ): Promise<ILogSearchSuggestResponse> =>
        this.post<ILogSearchSuggestResponse>(
            LOG_SEARCH_SUGGEST,
            logSearchSuggestParams,
        );

    searchHotels = async (
        searchParams: ISearchHotelsInfoRequestParams,
    ): Promise<ISearchHotelsInfo> => {
        return this.get<ISearchHotelsInfo>(SEARCH_HOTELS_POLLING, {
            params: searchParams,
        });
    };

    countHotels = (
        searchParams: ICountHotelsRequestParams,
    ): Promise<ICountHotelsResponse> =>
        this.get<ICountHotelsResponse>(SEARCH_COUNT_HOTELS, {
            params: searchParams,
        });

    getGeoRegionInfo = (
        regionParams: IGeoRegionInfoRequestParams,
    ): Promise<IGeoRegionInfoResponse> =>
        this.get<IGeoRegionInfoResponse>(GEO_REGION_INFO, {
            params: regionParams,
        });
}

export const browserHotelsSearchProvider = new BrowserHotelsSearchProvider();
