import {IHotelsSearchService} from 'server/services/HotelsServices/HotelsSearchService';
import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {browserHotelsSearchProvider} from './browserHotelsSearchProvider';

export const hotelsSearch = {
    provider(container?: IDependencies): IHotelsSearchService {
        return getProvider<'hotelsSearchService', IHotelsSearchService>(
            browserHotelsSearchProvider,
            'hotelsSearchService',
        )(container);
    },
};
