import {IHotelsExtranetPaymentsRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentsRequest';
import {IHotelsExtranetOrdersRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetOrdersRequest';
import {IHotelsExtranetOrdersResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetOrdersResponse';
import {IHotelsExtranetPaymentsResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentsResponse';
import {IHotelsExtranetAddHotelRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetAddHotelRequest';
import {IHotelsExtranetAddHotelResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetAddHotelResponse';
import {IHotelsExtranetApproveHotelResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetApproveHotelResponse';
import {IHotelsExtranetApproveHotelRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetApproveHotelRequest';
import {IHotelsListResponse} from 'server/api/HotelsExtranetApi/types/IHotelsListResponse';
import {IHotelsExtranetPaymentDetailsRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentDetailsRequest';
import {IHotelsExtranetPaymentDetailsResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentDetailsResponse';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IHotelsExtranetService} from 'server/services/HotelsExtranetService/HotelsExtranetService';

export class HotelsExtranetProvider
    extends BrowserHttpClient
    implements IHotelsExtranetService
{
    constructor() {
        super({baseURL: '/api/hotelsExtranet/'});
    }

    addHotel = (
        request: IHotelsExtranetAddHotelRequest,
    ): Promise<IHotelsExtranetAddHotelResponse> => {
        return this.post<IHotelsExtranetAddHotelResponse>('addHotel', request);
    };

    approveHotel = (
        request: IHotelsExtranetApproveHotelRequest,
    ): Promise<IHotelsExtranetApproveHotelResponse> => {
        return this.post<IHotelsExtranetApproveHotelResponse>(
            'approveHotel',
            request,
        );
    };

    getHotels = (): Promise<IHotelsListResponse> => {
        return this.get<IHotelsListResponse>('getHotels');
    };

    getOrders = (
        request: IHotelsExtranetOrdersRequest,
    ): Promise<IHotelsExtranetOrdersResponse> => {
        return this.post<IHotelsExtranetOrdersResponse>('getOrders', request);
    };

    getPayments = (
        request: IHotelsExtranetPaymentsRequest,
    ): Promise<IHotelsExtranetPaymentsResponse> => {
        return this.post<IHotelsExtranetPaymentsResponse>(
            'getPayments',
            request,
        );
    };

    getPaymentDetails = (
        params: IHotelsExtranetPaymentDetailsRequest,
    ): Promise<IHotelsExtranetPaymentDetailsResponse> => {
        return this.get<IHotelsExtranetPaymentDetailsResponse>(
            'getPaymentDetails',
            {params},
        );
    };
}

export const browserHotelsExtranetProvider = new HotelsExtranetProvider();
