import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

interface IMailApiCountersResponse {
    counters: {
        fresh: number;
        unread: number;
    };
}

const COUNTERS_OPTIONS = {
    params: {
        silent: true,
    },
    withCredentials: true,
};

export class MailApiProvider extends BrowserHttpClient {
    constructor() {
        super({
            baseURL: 'https://mail.yandex.ru/api/v2/travel',
        });
    }

    interceptRequest(request: IRequestConfig): void {
        // Убираем preflight-запрос, который не поддерживается api-шкой почты
        // @see https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS
        request.headers = {};
    }

    counters = async (): Promise<IMailApiCountersResponse> => {
        return this.get<IMailApiCountersResponse>('counters', COUNTERS_OPTIONS);
    };
}

export const browserProvider = new MailApiProvider();
