import {IDependencies} from 'server/getContainerConfig';
import {INotebookService} from 'server/services/NotebookService/NotebookService';

import {getProvider} from 'serviceProvider/core';
import {notebookBrowserProvider} from 'serviceProvider/notebook/notebookBrowserProvider';

export const notebook = {
    provider(container?: IDependencies): INotebookService {
        return getProvider<'notebookService', INotebookService>(
            notebookBrowserProvider,
            'notebookService',
        )(container);
    },
};
